#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BrokenRuleException : BaseTest 
	{
		private string exceptionText = "BrokenRuleException";
		private string innerText = "InnerException";
		private string genericErrorText = "Exception of type 'gov.va.med.vbecs.BOL.BrokenRuleException' was thrown.";
		
		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
		}
		
		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BrokenRuleException tmpBRE = new BOL.BrokenRuleException();

			Assert.IsNotNull(tmpBRE);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}


		[Test]
		public void Ctor_String_Pass()
		{
			BOL.BrokenRuleException tmpBRE = new BOL.BrokenRuleException(exceptionText);
			Assert.IsTrue(tmpBRE.Message == exceptionText);
		}

		[Test]
		public void Ctor_String_Fail()
		{
			BOL.BrokenRuleException tmpBRE = new BOL.BrokenRuleException(null);
			Assert.IsTrue(tmpBRE.Message == genericErrorText);
		}

		[Test]
		public void Ctor_String_Exception_Pass()
		{
			BOL.BrokenRuleException tmpBRE =  new BOL.BrokenRuleException(exceptionText, new Exception(innerText));

			Assert.IsTrue(exceptionText == tmpBRE.Message);
			Assert.IsTrue(innerText == tmpBRE.InnerException.Message);
		}

		[Test]
		public void Ctor_String_Exception_Fail()
		{

			BOL.BrokenRuleException tmpBRE =  new BOL.BrokenRuleException(null, null);

			Assert.IsTrue(genericErrorText == tmpBRE.Message);
			Assert.IsNull(tmpBRE.InnerException);
		}

		[Test]
		public void GetObjectData_Pass()
		{
			BrokenRuleException _originalXcp = new BrokenRuleException( "Test", null );
			BinaryFormatter _formatter = new BinaryFormatter();
			MemoryStream _stream = new MemoryStream();

			_formatter.Serialize( _stream, _originalXcp );

			_stream.Seek(0, SeekOrigin.Begin );

			BrokenRuleException _reincarnatedXcp = (BrokenRuleException)_formatter.Deserialize( _stream );
			
			Assert.IsNotNull( _reincarnatedXcp );
			Assert.AreEqual( _originalXcp.Message, _reincarnatedXcp.Message );
			Assert.AreEqual( _originalXcp.OSVersion, _reincarnatedXcp.OSVersion );
			Assert.AreEqual( _originalXcp.MachineName, _reincarnatedXcp.MachineName );
			Assert.AreEqual( _originalXcp.StackTrace, _reincarnatedXcp.StackTrace );
			Assert.AreEqual( _originalXcp.UserName, _reincarnatedXcp.UserName );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetObjectData_Fail()
		{
		}

		[Test]
		public void OSVersion_Pass()
		{
			BOL.BrokenRuleException tmpBRE = new BOL.BrokenRuleException(exceptionText);
			string tstValue = tmpBRE.OSVersion;

			Assert.IsTrue(tmpBRE.OSVersion == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OSVersion_Fail()
		{
		}


		[Test]
		public void UserName_Pass()
		{
			BOL.BrokenRuleException tmpBRE = new BOL.BrokenRuleException(exceptionText);
			string tstValue = tmpBRE.UserName;

			Assert.IsTrue(tmpBRE.UserName == tstValue);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UserName_Fail()
		{
		}


	}

}
#endif
